*************************************************************************
*			PERSISTENCE OF VISION 143 STFM PART		*
*			-----------------------------------		*
*									*
* Written by: 	MAC SYS DATA of PERSISTENCE OF VISION			*
*									*
*									*
* Music by:	Mad Max TFMX ripped by Grazey of PHF			*
*									*
*									*
* Grafix by: 	Machine System Data					*
*									*
*									*
* Date:		6/3/94							*
*									*
*									*
*			 Persistence Of Vision 1994			*
*									*
*************************************************************************
*
* ------------- READ ME --------------
*
* This code will print some text with rasters and play a TFMX tune.
* On pressing SPACE it will either exit or reset the ST.
*
* To add this to the STE version it has to be assembled to memory
* then go into MONST and press S, save from MSD to MSDEND-1 as STFM.DAT
*
* Now pack with Atomic 3.5 as data.
*
* Load the STE menu and assemble.
*
*
*
*
*
************************************************************************
msd
yes=1
no=0
final=no		;no for testing
			;yes for final version for incorporating into STE menu

		ifne	final
		org	$10000
		endc

		lea	bssstart,a0
		move.l	#bssend-bssstart,d0
clear_bss	clr.b	(a0)+
		sub.l	#1,d0
		bne	clear_bss

		jsr	set_up

;**************************************************************************
; The Final Music system eXtended ( TFMX ) Music Driver
; Original Amiga Program By Chris Hlsbeck (F5) and Jochen Hippel (Tex)
; ST Conversion By Jochen Hippel

; Music-Player hacked by Grazey From The P.H.F. Of Kingston-Upon-Hull
; Hacked - 23rd December 1992 while recovering from my works piss up
; uggghhhh........ All musics were hacked using MonST and Easyrider 4!
; ( wot no cartridge! )

; As far as I know, I've included all the TFMX songs which use Jochen's
; new ST music driver :-

;				Composed By	Converted By
;-----------------------------------------------------------------------
; Amberstar			Hippel		
; Lethal Xcess - Wings Of Death 2	Hippel

; PLEASE NOTE both these songs are compatible with this player BUT they use
; a different frequency table. So please change the following lines to
; to the tune you want to listen to.


amber	equ	yes
xcess	equ	no

; To hear more TFMX tunes get Ultimate Muzak Demo Volume 3, which contains
; Turrican 1 & 2, Z-Out, Warp, Great Giana Sisters, Quik & Silva etc

; Order your copy today!


; In the near future I'll also have a go at converting some tunes
; from the Amiga :-

; BC Kid, Cross-Out, Wings Of Death, Last Ninja Remix, Enchanted Land
; & 5th Gear
; Please credit me if you use any of these music hacks or the TFMX
; player, cheers!
; Hope you enjoy it!!
; Tabs ter 10



OUTPUT	equ	1

	moveq.l	#OUTPUT,d0		; Output
				; 	> 0 DMA/STe
				;	> 1 Yam/STFM
				;	> 2 ????
				;	> 3 Fast Yam/STFM
; I've not tested the STe output option but hopefully it'll work fine!


	moveq.l	#1,d1		; Tune Number
	jsr	start
; DONT USE A5,A6,D7 FROM HERE


main_loop	cmp.b	#$39,$fffffc02.w
		bne.s	main_loop


		ifne	final
		move.l	4.w,-(sp)
		rts
		endc
;******* shut tune down ****************
		moveq.l	#OUTPUT,d0		; Output < Remember this!
		jsr	stop

bp		bsr	set_isr_off
		jsr	set_old_palette

		move.w	#1,-(sp)
		move.l	#-1,-(sp)
		move.l	(sp),-(sp)
		move.w	#5,-(sp)
		trap	#14
		add.l	#12,sp

	move.b	#$8,$fffffc02.w
	jsr	set_user

	clr.w	-(sp)
	trap	#1



*******************
* CUSTOM ROUTINES *
*******************

*************************************************************************
*	NEW PRINT TITLES ROUT - NOW MASKS TO KEEP 16 COLOUR PIC		*
*									*
* Revision:	1.2 - now supports 6*6 font				*
* Date:		20/10/92						*
* By:		MSD 							*
*									*
* More comments added to allow others to understand			*
*									*
*************************************************************************
*
* Now is fully masking to give black line around letters.
*
* Here is a little option to allow you to print the titles in any colour
* simply enable the planes you require..
*
* If you disable them all the titles will be colour 0


ENABLE_PLANE1	equ	yes
ENABLE_PLANE2	equ	no
ENABLE_PLANE3	equ	no
ENABLE_PLANE4	equ	no

COLOUR0		equ	ENABLE_PLANE1+ENABLE_PLANE2+ENABLE_PLANE3+ENABLE_PLANE4

print_titles	lea	pic+34,a0		;alter this to move the titles down the screen
		add.w	#160*56,a0
		move.l	a0,a6
		lea	screen_titles,a1
		lea	screen_titles_font,a2
		lea	screen_titles_font+(80*6),a3

		move.w	#24-1,d0	;max titles per menu
.loop		move.w	#20-1,d6	;40 across each line (I know it says 20 but it's 20 words)
.loop2		moveq	#0,d1
		move.b	(a1)+,d1	;get ASCII char
		sub.w	#32,d1		;rid of ASCII
		mulu	#6,d1		;chars are 12 bytes each

BYTE_OFF	set	0
LINE_OFF	set	0

		REPT	6
		move.b	BYTE_OFF(a2,d1.w),d5	;get char
		move.b	BYTE_OFF(a3,d1.w),d3	;get char mask

		IFEQ	COLOUR0
		not.b	d5
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+0(a0),d4	;1st plane
		and.b	d5,d4
		move.b	d4,LINE_OFF+0(a0)	;poke data back to scrn
		ELSE	
		IFNE	ENABLE_PLANE1
		move.b	LINE_OFF+0(a0),d4	;1st plane
		and.b	d3,d4			;and mask with scrn data
		or.b	d5,d4			;or char data into mask
		move.b	d4,LINE_OFF+0(a0)	;poke data back to scrn
		ENDC
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+2(a0),d4	;2nd plane
		and.b	d5,d4
		move.b	d4,LINE_OFF+2(a0)
		ELSE
		IFNE	ENABLE_PLANE2
		move.b	LINE_OFF+2(a0),d4	;2nd plane
		and.b	d3,d4			;use same mask calculated previously
		or.b	d5,d4
		move.b	d4,LINE_OFF+2(a0)
		ENDC
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+4(a0),d4	;3rd plane
		and.b	d5,d4
		move.b	d4,LINE_OFF+4(a0)
		ELSE
		IFNE	ENABLE_PLANE3
		move.b	LINE_OFF+4(a0),d4	;3rd plane
		and.b	d3,d4
		or.b	d5,d4
		move.b	d4,LINE_OFF+4(a0)
		ENDC
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+6(a0),d4	;4th plane
		and.b	d5,d4
		move.b	d4,LINE_OFF+6(a0)
		ELSE
		IFNE	ENABLE_PLANE4
		move.b	LINE_OFF+6(a0),d4	;4th plane
		and.b	d3,d4
		or.b	d5,d4
		move.b	d4,LINE_OFF+6(a0)
		ENDC
		ENDC


BYTE_OFF	set	BYTE_OFF+1
LINE_OFF	set	LINE_OFF+160
		ENDR


BYTE_OFF	set	0
LINE_OFF	set	0
		moveq	#0,d1
		move.b	(a1)+,d1	;get ASCII char
		sub.w	#32,d1		;rid of ASCII

		mulu	#6,d1		;chars are 6 bytes each

		REPT	6
		move.b	BYTE_OFF(a2,d1.w),d5
		move.b	BYTE_OFF(a3,d1.w),d3

		IFEQ	COLOUR0
		not.b	d5
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+1(a0),d4	;1st plane
		and.b	d5,d4
		move.b	d4,LINE_OFF+1(a0)
		ELSE
		IFNE	ENABLE_PLANE1
		move.b	LINE_OFF+1(a0),d4	;1st plane
		and.b	d3,d4
		or.b	d5,d4
		move.b	d4,LINE_OFF+1(a0)
		ENDC
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+3(a0),d4	;2nd
		and.b	d5,d4
		move.b	d4,LINE_OFF+3(a0)
		ELSE
		IFNE	ENABLE_PLANE2
		move.b	LINE_OFF+3(a0),d4	;2nd
		and.b	d3,d4
		or.b	d5,d4
		move.b	d4,LINE_OFF+3(a0)
		ENDC
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+5(a0),d4	;3rd
		and.b	d5,d4
		move.b	d4,LINE_OFF+5(a0)
		ELSE
		IFNE	ENABLE_PLANE3
		move.b	LINE_OFF+5(a0),d4	;3rd
		and.b	d3,d4
		or.b	d5,d4
		move.b	d4,LINE_OFF+5(a0)
		ENDC
		ENDC

		IFEQ	COLOUR0
		move.b	LINE_OFF+7(a0),d4	;4th
		and.b	d5,d4
		move.b	d4,LINE_OFF+7(a0)
		ELSE
		IFNE	ENABLE_PLANE4
		move.b	LINE_OFF+7(a0),d4	;4th
		and.b	d3,d4
		or.b	d5,d4
		move.b	d4,LINE_OFF+7(a0)
		ENDC
		ENDC

BYTE_OFF	set	BYTE_OFF+1
LINE_OFF	set	LINE_OFF+160
		ENDR

		lea	8(a0),a0
		dbf	d6,.loop2
		lea	160*6(a6),a6
		move.l	a6,a0
		dbf	d0,.loop
		rts

screen_titles
;TITLES AS THEY WILL APPEAR ON THE MENU........ (MAX 40 CHARS)
;          ------1234567890123456789012345678901234567890------
	dc.b	"aeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeb"
	dc.b	"g      PERSISTENCE OF VISION 144       h"
	dc.b	"g                                      h"
	dc.b	"g ALL DEMOS ON THIS DISC ONLY WORK ON  h"
	dc.b	"g  AN STE OR HIGHER SPEC MACHINE AND   h"
	dc.b	"g    YOU DON'T APPEAR TO HAVE ONE.     h"
	dc.b	"g                                      h"
	dc.b	"g  1:CRISTINA IS A DREAM 2:ETERNITY    h"
	dc.b	"g  3:ARMADA              4:ICE INTRO   h"
	dc.b	"g             5:COPIER                 h"
	dc.b	"g     CREDITS FOR THIS MENU GOTO...    h"
	dc.b	"g                                      h"
	dc.b	"g      ALL CODING BY: MAC SYS DATA     h"
	dc.b	"g                                      h"
	dc.b	"g         FONT BY: MAC SYS DATA        h"
	dc.b	"g                                      h"
	dc.b	"g         LOGO BY: OZYMANDIAS          h"
	dc.b	"g                                      h"
	dc.b	"g  'AMBERSTAR' TFMX MUSIC BY: MAD MAX  h"
	dc.b	"g                                      h"
	dc.b	"g    MUSIC RIPPED BY: GRAZEY OF PHF    h"
	dc.b	"g                                      h"
	dc.b	"g          PRESS SPACE TO QUIT         h"
	dc.b	"dffffffffffffffffffffffffffffffffffffffc"
	even

screen_titles_font	incbin	6x6_font.dat


***********************
* SUBROUTINES SECTION *
***********************
set_user
	move.l	stack_save,-(sp)
	move.w	#$20,-(sp)
	trap	#1
	addq.l	#6,sp
	rts


set_old_palette
	lea	old_palette,a0
set_pal	lea	$ffff8240.w,a1
	movem.l	(a0),d0-d7
	movem.l	d0-d7,(a1)
	rts




set_up
		ifeq	final
		clr.l	-(sp)		;supervisor
		move.w	#$20,-(sp)
		trap	#1
		addq.l	#6,sp
		move.l	d0,stack_save
		move.b	#$12,$fffffc02.w	;DI mouse
		endc

		move.w	#3,-(sp)	;get screen base
		trap	#14
		addq.l	#2,sp
		move.l	d0,screen_base

		move.w	#4,-(sp)	;get_original_rez
		trap	#14
		addq.l	#2,sp
		move.w	d0,original_rez

		movem.l	$ffff8240.w,d0-d7
		movem.l	d0-d7,old_palette

		movem.l	pic+2,d0-d7
		movem.l	d0-d7,$ffff8240.w

		clr.w	-(sp)
		move.l	#-1,-(sp)
		move.l	(sp),-(sp)
		move.w	#5,-(sp)
		trap	#14
		add.l	#12,sp

		move.l	#screens,d0
		clr.b	d0
		move.l	d0,scr_now

		jsr	print_titles

		lea	pic+34,a0
		move.l	scr_now,a1
		move.l	a1,a2
		move.w	#32000/4-1,d0
.show		move.l	(a0)+,(a1)+
		dbf	d0,.show

		bsr	set_isr

set_screen	move.l	scr_now,d6
		lsr.l	#8,d6
		lea	$ffff8201.w,a4
		movep.w	d6,(a4)
		rts

set_isr		move.l	$120.w,old_timerb
		move.b	$fffffa09.w,a09
		move.b	$fffffa07.w,a07
		move.b	$fffffa13.w,a13
		and.b	#$df,$fffffa09.w
		and.b	#$fe,$fffffa07.w
		clr.b	$fffffa1b.w
		move.l	#stfminittimerb,$120.w
		or.b	#1,$fffffa07.w
		or.b	#1,$fffffa13.w
		rts
stfminittimerb	clr.b	$fffffa1b.w
		move.l	#stfmtimerb,$120.w
		move.b	#6,$fffffa21.w
		move.b	#8,$fffffa1b.w
		rte
stfmtimerb	move.w	#0,$ffff8242.w
		move.l	a2,-(sp)
		move.l	colour_pos,a2
		move.w	(a2)+,stfmtimerb+2
		move.l	a2,colour_pos
		move.l	(sp)+,a2
		rte
set_isr_off	move.w	#$2700,sr
		and.b	#$df,$fffffa09.w
		and.b	#$fe,$fffffa07.w
		move.l	old_timerb,$120.w
		move.b	a07,$fffffa07.w
		move.b	a09,$fffffa09.w
		move.b	a13,$fffffa13.w
		move.w	#$2300,sr
		rts
old_timerb	dc.l	0
a07		dc.b	0
a09		dc.b	0
a13		dc.b	0
	even
colour_pos	dc.l	colours
colours
	dc.w	$708
 dc.w	$708,$e01,$609,$d02,$50a,$c03,$40b,$b04,$30c,$a05,$20d,$906,$10e,$807,$00f
 dc.w	$08f,$01f,$09f,$02f,$0af,$03f,$0bf,$04f,$0cf,$05f,$0df,$06f,$0ef,$07f,$0ff

 dc.w	$0ff,$07f,$0ef,$06f,$0df,$05f,$0cf,$04f,$0bf,$03f,$0af,$02f,$09f,$01f,$08f
 dc.w	$00f,$807,$10e,$906,$20d,$a05,$30c,$b04,$40b,$c03,$50a,$d02,$609,$e01,$708
 dc.w	$f00,$f80,$f10,$f90,$f20,$fa0,$f30,$fb0,$f40,$fc0,$f50,$fd0,$f60,$fe0,$f70
 dc.w	$ff0,$7f0,$ef0,$6f0,$df0,$5f0,$cf0,$4f0,$bf0,$3f0,$af0,$2f0,$9f0,$1f0,$8f0
 dc.w	$0f0,$070,$0e0,$060,$0d0,$050,$0c0,$040,$0b0,$030,$0a0,$020,$090,$010,$080



start	bra	startmusic
stop	bra	stopmusic 
	jmp	l0087 
stop_ste:	clr.w	$ffff8900.w 
	rts 

init_microwire:
	move.w	#$7ff,$ffff8924.w 
	move.w	#$e8,d0 
	bsr.s	send_to_microwir
	move.w	#$154,d0
	bsr.s	send_to_microwir
	move.w	#$114,d0
	bsr.s	send_to_microwir
	move.w	#$88,d0 
	bsr.s	send_to_microwir
	move.w	#$47,d0 
	bsr.s	send_to_microwir
	moveq.w	#1,d0 
	bsr.s	send_to_microwir
	rts 

send_to_microwir: 
	ori.w	#$400,d0
	move.w	#$3e8,d7
wait:	dbf	d7,wait 
	move.w	d0,$ffff8922.w
	rts 

init_stetimer
	lea	$ffff8900.w,a6
	clr.w	(a6)
	sf	$fffffa19.w 
	move.w 	#1,32(a6) 
	move.l	#ste_timera,$134.w
	bset	#5,$fffffa0b.w
	bclr	#5,$fffffa0f.w
	move.b	#1,$fffffa1f.w
	bset	#5,$fffffa13.w
	bset	#5,$fffffa07.w
	move.l	#stebuffer1,addrout 
	move.b	l000a(pc),3(a6) 
	move.b	l000b(pc),5(a6) 
	move.b	l000c(pc),7(a6) 
	move.l	#addrout,addrout
	move.b	l000a(pc),15(a6)
	move.b	l000b(pc),17(a6)
	move.b	l000c(pc),19(a6)
	move.b	#8,$fffffa19.w
	move.w	#1,(a6) 
	rts 

	dcb.w	8,0 

stepointer:
	dc.l	stebuffer1
l0006	dc.l	stebuffer2
stebuffer1:
	dcb.w	236,0 
stebuffer2:
	dcb.w	236,0 
addrout:	dc.b	$00 
l000a:	dc.b	$00 
l000b:	dc.b	$00 
l000c:	dc.b	$00 

ste_timera	move	#$2300,sr
		cmpi.b	#$24,(a7)
		bne.b	l000e
		jsr	my_vbl
l000e		movem.l	a0-a6/d0-d7,-(a7)
		movea.l	stepointer(pc),a4
		move.l	l0006(pc),stepointer
		move.l	a4,l0006
		move.l	a4,addrout
		lea	$ffff8900.w,a6
		move.w	#1,(a6)
		move.b	l000a(pc),3(a6)
		move.b	l000b(pc),5(a6)
		move.b	l000c(pc),7(a6)
		addi.l	#$1d8,addrout
		move.b	l000a(pc),15(a6)
		move.b	l000b(pc),17(a6)
		move.b	l000c(pc),19(a6)
		bsr	vblwork
		sf	$fffffa19.w 
		move.b	#1,$fffffa1f.w
		move.b	#8,$fffffa19.w
		movem.l	(a7)+,a0-a6/d0-d7 
		rte

change_freq:
	movem.l	a0/d0-d1,-(a7)
	lea	freqtab(pc),a0
	andi.w	#$f,d0
	add.w	d0,d0 
	add.w	d0,d0 
	move.w	d0,d1 
	add.w	d0,d0 
	add.w	d1,d0 
	adda.w	d0,a0 
	move.l	(a0)+,bittner 
	move.l	(a0)+,d0

	ifne	xcess
	subi.w	#$6,d0
	elseif	
	subi.w	#$1e,d0
	endc 

	subq.w	#1,d0 
	move.w	d0,l0039
	move.l	(a0)+,d0
	tst.w	output
	beq.b	l0010 
	move.b	d0,$fffffa23.w
l0010:	movem.l	(a7)+,a0/d0-d1
	rts 

startmusic
	move.w	d0,output
	jsr	init_soundtracke
	jsr	mega_init
	movea.w	#$8800,a0
	moveq	#0,d0
	movep.w	d0,0(a0)
	move.w	#$100,d0
	movep.w	d0,0(a0)
	move.w	#$200,d0
	movep.w	d0,0(a0)
	move.w	#$300,d0
	movep.w	d0,0(a0)
	move.w	#$400,d0
	movep.w	d0,0(a0)
	move.w	#$500,d0
	movep.w	d0,0(a0)
	move.w	#$a00,d0
	movep.w	d0,0(a0)
	move.w	#$7f8,d0
	movep.w	d0,0(a0)
	lea	old_mfp(pc),a0
	move.b	$fffffa07.w,(a0)+ 
	move.b	$fffffa09.w,(a0)+ 
	move.b	$fffffa13.w,(a0)+ 
	move.b	$fffffa15.w,(a0)+ 
	move.b	$fffffa17.w,(a0)+ 
	move.b	$fffffa19.w,(a0)+ 
	move.b	$fffffa1d.w,(a0)+ 
	move.b	$fffffa1f.w,(a0)+ 
	move.l	$70.w,old_level4
	move.l	$134.w,old_tmra 
	move.l	$114.w,old_tmrc 
	move.l	#leervbl,$90.w
	clr.w	$94.w 
	move.l	#vblrout,$70.w
	sf	$fffffa1d.w 
	tst.b	ad
	bne.b	l0017 
	st	ad
	cmpi.w	#2,output 
	bne.b	l0014 
	lea	soundtab(pc),a0 
	move.w	#$17f,d0
	move.w	#0,d1 
	move.w	#$ffff,d2 
l0012:	move.w	d1,(a0)+
	move.w	d2,5118(a0) 
	addq.l	#6,a0 
	dbf	d0,l0012
	move.w	#$ff,d0 
l0013:	move.w	d1,(a0)+
	addi.w	#$100,d1
	addq.l	#6,a0 
	dbf	d0,l0013
	bra.b	l0016 
l0014:	lea	soundtab(pc),a0 
	move.w	#$3ff,d7
l0015:	move.b	5(a0),6(a0) 
	addq.l	#8,a0 
	dbf	d7,l0015
l0016:	jsr	init_voltabs
l0017:
	ifne	xcess
		moveq	#10,d0 
	elseif	
		moveq	#9,d0 
	endc 
	bsr	change_freq 
	move.w	l0039(pc),bytes 
	bclr	#3,$fffffa17.w
	tst.w	output
	beq.b	l0018 
	bset	#5,$fffffa15.w
	bset	#5,$fffffa09.w
l0018:	moveq	#0,d0 
	move.l	d0,freq1
	move.l	d0,freq2
	move.l	d0,freq3
	move.l	d0,freq4
	sf	wset1 
	sf	wset2 
	sf	wset3 
	sf	wset4 
	move.w	#0,dmacon 
	move.w	#$fff0,d0 
	move.l	d0,d1 
	move.l	d0,d2 
	move.l	d0,d3 
	lea	blankend,a0 
	movea.l	a0,a1 
	movea.l	a0,a2 
	movea.l	a0,a3 
	movem.l	a0-a3/d0-d3,regstore
	move.l	#blankend,loopv1
	move.l	#blankend,loopv2
	move.l	#blankend,loopv3
	move.l	#blankend,loopv4
	move.w	#$100,loopd1
	move.w	#$100,loopd2
	move.w	#$100,loopd3
	move.w	#$100,loopd4
	tst.w	output
	beq	dma_output
	move.l	#buffer1,newbuffer
	move.l	#buffer2,oldbuffer
	movea.l	newbuffer(pc),a4
	movem.l	regstore(pc),a0-a3/d0-d3
	moveq	#0,d5 
	move.w	bytes(pc),d5
	bsr	calc_channels 
	move.w	#1,(a4)+
	movea.l	oldbuffer(pc),a4
	movem.l	regstore(pc),a0-a3/d0-d3
	moveq	#0,d5 
	move.w	bytes(pc),d5
	bsr	calc_channels 
	move.w	#1,(a4)+
	movea.l	oldbuffer(pc),a6
	movea.w	#$8800,a5 
	move.l	#new_output,$114.w
	move.l	#schulz,$c.w
	ifne	xcess
		moveq	#10,d0 
	elseif	
		moveq	#9,d0 
	endc 
	bsr	change_freq 
	cmpi.w	#2,output 
	bne.b	l0019 
	move.l	#new_output2,$114.w 
	move.l	#schulz2,$c.w 
	move.l	#$e0e2020,(a5)
	move.l	#$8080000,(a5)
	move.l	#$9090000,(a5)
	move.l	#$a0a0000,(a5)
	move.l	#$707ffff,(a5)
	bset	#0,$fffffa05.w
	bset	#0,$fffffa01.w
	ifne	xcess
		moveq	#$b,d0 
	elseif	
		moveq	#$a,d0 
	endc 
	bsr	change_freq 
	move.w	#$f00,(a5)+ 
l0019:	move.w	l0039(pc),bytes 
	move.b	#$10,$fffffa1d.w
	rts

dma_output
	movem.l	regstore,a0-a3/d0-d3
	movea.l	#stebuffer1,a4
	moveq	#0,d5 
	move.w	#$eb,d5 
	bsr	calc_channels 
	movem.l	regstore,a0-a3/d0-d3
	movea.l	#stebuffer2,a4
	moveq	#0,d5 
	move.w	#$eb,d5 
	bsr	calc_channels 
	moveq	#7,d0 
	bsr	change_freq 
	move.w	l0039(pc),bytes 
	bsr	init_microwire
	bra	init_stetimer 

stopmusic:
	tst.w	output
	bne.b	l001c
	bsr	stop_ste
l001c:	move	sr,-(a7)
	move	#$2700,sr 
	move.l	old_tmra(pc),$134.w 
	move.l	old_tmrc(pc),$114.w 
	move.l	old_level4(pc),$70.w
	lea	old_mfp(pc),a0
	move.b	(a0)+,$fffffa07.w 
	move.b	(a0)+,$fffffa09.w 
	move.b	(a0)+,$fffffa13.w 
	move.b	(a0)+,$fffffa15.w 
	move.b	(a0)+,$fffffa17.w 
	move.b	(a0)+,$fffffa19.w 
	move.b	(a0)+,$fffffa1d.w 
	move.b	(a0)+,$fffffa1f.w 
	move.b	#$c0,$fffffa23.w
	move	(a7)+,sr
	rts 

vblwork:
	jsr	rout
	movem.l	regstore,a0-a3/d0-d3
	tst.w	output
	bne.b	l001e 
	moveq	#0,d5 
	move.w	#$eb,d5 
	bsr	calc_channels 
	bra.b	l001f 
l001e:	moveq	#0,d5 
	move.w	bytes(pc),d5
	bsr	calc_channels 
	move.w	#1,(a4)+
l001f:	tst.w	d0
	bmi.b	l0020 
	movea.l	loopv1(pc),a0 
	sub.w	loopd1(pc),d0 
l0020:	tst.w	d1
	bmi.b	l0021 
	movea.l	loopv2(pc),a1 
	sub.w	loopd2(pc),d1 
l0021:	tst.w	d2
	bmi.b	l0022 
	movea.l	loopv3(pc),a2 
	sub.w	loopd3(pc),d2 
l0022:	tst.w	d3
	bmi.b	l0023 
	movea.l	loopv4(pc),a3 
	sub.w	loopd4(pc),d3 
l0023:	movem.l	a0-a3/d0-d3,regstore
	rts 

oldsuperstack:
	dcb.w	2,0 
freq1:	dcb.w	2,0 


ste_output
	dc.b	'~',$00,'>:',$00,$DC,$06,$87
	dc.b	$00,$00,$00,'|3',$C7
	dc.l	laut1ste
	dc.b	'>:',$00,$D8,$06,$87,$00,$00
	dc.b	$00,'|3',$C7
	dc.l	laut2ste
	dc.b	'>:',$00,$D6,$06,$87,$00,$00
	dc.b	$00,'t3',$C7
	dc.l	laut3ste
	dc.b	'>:',$00,$D4,$06,$87,$00,$00
	dc.b	$00,'v3',$C7
	dc.l	laut4ste
	dc.b	'#',$F9 
	dc.l	freq4
	dc.l	freq4ste
	dc.b	',:',$FF,$AE,'*z',$00,$CA 
	dc.b	',z',$00,$CE,'><',$00,$80 
l0027:	dc.b	'HE',$18,'0',$00,$00,'O',$FA
laut1ste:	dc.b	$01,$DA,$18,'7@',$00,$1A,'1'
	dc.b	$10,$00,'O',$FA 
laut2ste:	dc.b	$01,$CE,$1A,'7P',$00,$D8,'E'
	dc.b	$E2,'L',$BF,'D',$18,$C4,$98,'D' 
	dc.b	$18,'2 ',$00,'O',$FA
laut3ste:	dc.b	$01,$B8,$18,'7@',$00,$1A,'3'
	dc.b	'0',$00,'O',$FA 
laut4ste:	dc.b	$01,$AC,$1A,'7P',$00,$D8,'E'
	dc.b	$E2,'L',$BF,'D',$18,$C4,$98,'D' 
	dc.b	$D0,$86,$D1,'D',$D2,$8D,$D3,'D' 
	dc.b	$D4,$8E,$D5,'D',$06,$83 
freq4ste:	dc.b	$12,'4' 

	addq.w	#3,$ffffd744.w
	swap	d5
	dbf	d5,l0027
	movea.l	oldsuperstack(pc),a7
	rts 

calc_channels:
	move.l	a7,oldsuperstack
	clr.w	d4
	tst.w	output
	beq	ste_output
	move.l	freq1(pc),d6
calc_loop:
	swap	d5
	move.b	0(a0,d0.w),d5 
	lea	laut_tabs(pc),a7
laut1	equ	*-2 
	move.b	0(a7,d5.w),d4 
	move.b	0(a1,d1.w),d5 
	lea	laut_tabs(pc),a7
laut2	equ	*-2 
	move.b	0(a7,d5.w),d5 
	add.w	d5,d4 
	move.b	0(a2,d2.w),d5 
	lea	laut_tabs(pc),a7
laut3	equ	*-2 
	move.b	0(a7,d5.w),d5 
	add.w	d5,d4 
	move.b	0(a3,d3.w),d5 
	lea	laut_tabs(pc),a7
laut4	equ	*-2 
	move.b	0(a7,d5.w),d5 
	add.w	d5,d4 
	lsl.w	#3,d4 
	move.w	d4,(a4)+
	sub.w	d4,d4 
	add.l	d6,d0 
	addx.w	d4,d0 
	addi.l	#$12345678,d1 
freq2	equ	*-4 
	addx.w	d4,d1 
	addi.l	#$12345678,d2 
freq3	equ	*-4 
	addx.w	d4,d2 
	addi.l	#$12345678,d3 
freq4	equ	*-4 
	addx.w	d4,d3 
	swap	d5
	dbf	d5,calc_loop
	movea.l	oldsuperstack(pc),a7
	rts 

	dcb.w	128,0 
laut_tabs:
	dcb.w	12288,0 
bittner:	dcb.w	2,0 
bytes:	dc.b	$00,$00 
l0039:	dc.b	$00,$00 

	ifne	xcess
freqtab:		incbin	"g:\music\grazey\lethal_x.phf\lethal.frq"
	elseif	
freqtab:		incbin	"amber.frq"
	endc 
	even

voice1dat	dcb.w	2,0 
l003c:	dc.b	$00,$00 
l003d:	dcb.w	2,0 
loopv1:	dcb.w	2,0 
loopd1:	dcb.w	2,0 

voice2dat	dcb.w	2,0 
l0041:	dc.b	$00,$00 
l0042:	dcb.w	2,0 
loopv2:	dcb.w	2,0 
loopd2:	dcb.w	2,0 

voice3dat	dcb.w	2,0 
l0046:	dc.b	$00,$00 
l0047:	dcb.w	2,0 
loopv3:	dcb.w	2,0 
loopd3:	dcb.w	2,0
voice4dat	dcb.w	2,0 
l004b:	dc.b	$00,$00 
l004c:	dcb.w	2,0 
loopv4:	dcb.w	2,0 
loopd4:	dcb.w	2,0 

old_tmrc:	dcb.w	2,0 
old_tmra:	dcb.w	2,0 
old_level4:
	dcb.w	2,0 
old_mfp:	dcb.w	12,0
newbuffer:
	dcb.w	2,0 
oldbuffer:
	dcb.w	2,0 
regstore:	dcb.w	2,0 
l0056:	dcb.w	2,0 
l0057:	dcb.w	2,0 
l0058:	dcb.w	10,0
dmacon:	dc.b	$00 
l005a:	dc.b	$00 
wset1:	dc.b	$00 
wset2:	dc.b	$00 
wset3:	dc.b	$00 
wset4:	dc.b	$00 
ad:	dc.b	$00,$00 

new_output2	move.w	(a6)+,d7
		move.w	soundtab(pc,d7.w),(a5)
		rte

schulz2:	movea.l	newbuffer,a6
		move.w	(a6)+,d7
		move.w	soundtab(pc,d7.w),(a5)
		bra.b	goon_yeah 
new_output
	move.w	(a6)+,d7
	move.l	l0067(pc,d7.w),(a5) 
	move.l	soundtab(pc,d7.w),d7
	movep.l	d7,0(a5)
	rte

schulz:	movea.l	newbuffer,a6
	move.w	(a6)+,d7
	move.l	l0067(pc,d7.w),(a5) 
	move.l	soundtab(pc,d7.w),d7
	movep.l	d7,0(a5)
goon_yeah:	
	lea	14(a7),a7 
	move	#$2300,sr 
	cmpi.b	#$24,(a7) 
	bne.b	l0065 
	jsr	my_vbl
l0065:	movem.l	a0-a4/d0-d6,-(a7) 
	movea.l	oldbuffer(pc),a4
	move.l	newbuffer(pc),oldbuffer 
	move.l	a4,newbuffer
	jsr	vblwork 
	movem.l	(a7)+,a0-a4/d0-d6 
	move.w	l0039(pc),bytes 
	rte

soundtab:	dc.b	$08,$00,$09,$00 
l0067:	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$00,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$02,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$03,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$04,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$05,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$05,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$06,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$06,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$06,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$07,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$07,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$07,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$08,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$09,$09,$05 
	dc.b	$0a,$01,$00,$00,$08,$0a,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0a,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$06 
	dc.b	$0a,$02,$00,$00,$08,$0a,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0a,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0b,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$06 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$02,$00,$00,$08,$0b,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$01,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0b,$09,$08 
	dc.b	$0a,$04,$00,$00,$08,$0b,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$05 
	dc.b	$0a,$01,$00,$00,$08,$0c,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$06 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$07 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0c,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0c,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$02 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$06 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$07 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$08 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$01,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0d,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$01,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$02,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$03,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$04,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0d,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$04 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0e,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$06 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$07 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$08 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$02,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0e,$09,$0b 
	dc.b	$0a,$09,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$00,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$01,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$03,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0e,$09,$0c 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$00 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$01 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$03 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$04 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$04 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$05 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$05 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$06 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$06 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$07 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$08 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$09 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0a 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$02,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0b 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$04,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$05,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$06,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$07,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$08,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$09,$00,$00,$08,$0f,$09,$0c 
	dc.b	$0a,$0a,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$00,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$01,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00,$08,$0f,$09,$0d 
	dc.b	$0a,$03,$00,$00 

buffer1:	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff 

buffer2:	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$02,$00,$02,$00,$02,$00,$02,$00 
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff 

vblrout		move.l	#colours+2,colour_pos
		clr.b	$fffffa1b.w
		move.l	#stfminittimerb,$120.w
		move.w	colours,stfmtimerb+2
		move.b	#50-6,$fffffa21.w
		move.b	#8,$fffffa1b.w

		move	#$2700,sr 
		tst.w	$94.w 
		bne.b	l006b 
		bsr.b	my_vbl
l006b		clr.w	$94.w 
		rte

my_vbl	movem.l	a0-a4/d0-d6,-(a7) 
	addq.w	#1,$94.w
	movea.l	$90.w,a0
	jsr	 (a0)
	movem.l	(a7)+,a0-a4/d0-d6 
leervbl	rts 

set_freqs:
	movem.l	a0-a3/d0-d3,-(a7) 
	lea	laut_tabs,a3
	move.l	bittner(pc),d3
	lea	voice1dat(pc),a0
	lea	laut1,a1
	lea	freq1,a2
	bsr.s	emulate_vol_freq
	lea	voice2dat(pc),a0
	lea	laut2,a1
	lea	freq2,a2
	bsr.s	emulate_vol_freq
	lea	voice3dat(pc),a0
	lea	laut3,a1
	lea	freq3,a2
	bsr.s	emulate_vol_freq
	lea	voice4dat(pc),a0
	lea	laut4,a1
	lea	freq4,a2
	bsr.s	emulate_vol_freq
	movem.l	(a7)+,a0-a3/d0-d3 
	rts 

emulate_vol_freq: 
	move.w	6(a0),d0
	beq.b	l0071 
	move.w	8(a0),d2
	andi.w	#$ff,d2 
	cmp.w	#$40,d2 
	blt.b	l0070 
	moveq	#$3f,d2 
l0070:	mulu	#$180,d2
	move.l	d3,d1 
	divu	d0,d1 
	andi.l	#$ffff,d1 
	lsl.l	#5,d1 
	swap	d1
	move.l	d1,(a2) 
	movea.l	a3,a0 
	suba.l	a1,a0 
	add.l	a0,d2 
	move.w	d2,(a1) 
l0071:	rts 

set_waves:	
	movem.l	a0-a4/d0-d1,-(a7) 
	lea	l005a(pc),a2
	moveq	#0,d0 
	lea	freq1,a3
	lea	wset1(pc),a4
	lea	regstore(pc),a1 
	lea	voice1dat(pc),a0
	bsr.s	emulate_dma 
	moveq	#1,d0 
	lea	freq2,a3
	lea	wset2(pc),a4
	lea	l0056(pc),a1
	lea	voice2dat(pc),a0
	bsr.s	emulate_dma 
	moveq	#2,d0 
	lea	freq3,a3
	lea	wset3(pc),a4
	lea	l0057(pc),a1
	lea	voice3dat(pc),a0
	bsr.s	emulate_dma 
	moveq	#3,d0 
	lea	freq4,a3
	lea	wset4(pc),a4
	lea	l0058(pc),a1
	lea	voice4dat(pc),a0
	bsr.s	emulate_dma 
	movem.l	(a7)+,a0-a4/d0-d1 
	rts 

emulate_dma:
	btst	d0,(a2) 
	bne.b	l0074 
	clr.l	(a3)
	move.l	#$ff00,(a1) 
	move.l	#blankend,16(a1)
	move.w	#$200,14(a0)
	move.l	16(a1),10(a0) 
	st	(a4)
	rts 

l0074:	move.l	(a0),d0 
	move.w	4(a0),d1
	andi.l	#$3fff,d1 
	cmp.w	#$140,d1
	bge.b	l0075 
	move.l	#blank,d0 
	move.w	#$154,d1
l0075:	add.l	d1,d1 
	add.l	d1,d0 
	move.l	d0,10(a0) 
	move.w	d1,14(a0) 
	tst.b	(a4)
	beq.b	l0076 
	sf	(a4)
	move.l	d0,16(a1) 
	neg.l	d1
	move.l	d1,(a1) 
l0076:	rts 

init_voltabs:
	lea	laut_tabs,a0
	moveq	#0,d7 
	moveq	#$3f,d0 
lautloop1	moveq	#0,d6 
	move.w	#$ff,d1 
lautloop2	move.w	d6,d2 
	ext.w	d2
	muls	d7,d2 
	divs	#$3f,d2 
	addi.b	#$80,d2 
	move.b	d2,(a0)+
	addq.w	#1,d6 
	dbf	d1,lautloop2
	move.w	#$1f,d6 
l007a:	clr.l	(a0)+ 
	dbf	d6,l007a
	addq.w	#1,d7 
	dbf	d0,lautloop1
	rts 

output		dc.b	0
		even 

init_soundtracke	moveq	#1,d0 
			bra	 xmus

blank:	dcb.w	768,0 
blankend:	dcb.w	100,0 

mega_init	movea.l	samplebasis(pc),a0
	lea	samplebuffer,a1 
	lea	l00e3,a2
l0080:	move.b	-(a1),-(a2) 
	cmpa.l	a0,a1 
	bne.b	l0080 
	movea.l	samplebase(pc),a0 
	movea.l	samplebasis(pc),a1
	movea.l	a1,a6 
	adda.l	#$10000,a1
	move.l	a6,samplesub
	move.w	songfile+50,d7
	subq.w	#1,d7 
l0081:	movea.l	(a0),a2 
	move.l	a6,(a0) 
	subi.l	#$10000,(a0)+ 
samplesub	equ	 *-4 
	adda.l	a1,a2 
	movea.l	a2,a3 
	moveq	#0,d1 
	move.w	(a0)+,d0
	subq.w	#1,d0 
	move.w	(a0)+,d1
	adda.l	d1,a3 
	move.w	(a0)+,d1
	add.w	d1,d1 
	bsr.s	make_sample 
	dbf	d7,l0081
	rts 

make_sample:
	move.w	(a2)+,(a6)+ 
	dbf	d0,make_sample
	movea.l	a3,a4 
	movea.l	a3,a2 
	adda.l	d1,a4 
	move.w	#$257,d0
l0084:	cmpa.l	a4,a2 
	bne.b	l0085 
	movea.l	a3,a2 
l0085:	move.b	(a2)+,(a6)+ 
	dbf	d0,l0084
	rts 

xmus		bra.s	songinit2 
		bra	 rout

l0087		pea	(a0)
		lea	fade_out(pc),a0 
		move.w	d0,(a0) 
		movea.l	(a7)+,a0
		rts 

songinit2:
	movem.l	a0-a6/d0-d7,-(a7) 
	moveq	#1,d0 
	lea	songfile,a0 
	move.w	d0,-(a7)
	bsr.s	soundinit 
	move.w	(a7)+,d0
	bne.s	l0089 
	lea	l00c5(pc),a6
	st	(a6)
	bra.b	l008a 
l0089:	movea.l	songbase(pc),a1 
	subq.l	#1,d0 
	add.w	d0,d0 
	move.w	d0,d1 
	add.w	d0,d0 
	add.w	d1,d0 
	adda.w	d0,a1 
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	lea	speedsyn(pc),a6 
	move.w	(a1),(a6)+
	move.w	(a1)+,(a6)+ 
	bsr	init
l008a:	movem.l	(a7)+,a0-a6/d0-d7 
	rts 

soundinit	lea	sogbase(pc),a2
	move.l	a0,(a2) 
	movea.l	4(a0),a1
	adda.l	a0,a1 
	lea	arpstart(pc),a2 
	move.l	a1,(a2) 
	movea.l	8(a0),a1
	adda.l	a0,a1 
	lea	adsrstart(pc),a2
	move.l	a1,(a2) 
	movea.l	12(a0),a1 
	adda.l	a0,a1 
	lea	seqbase(pc),a2
	move.l	a1,(a2) 
	movea.l	16(a0),a1 
	adda.l	a0,a1 
	lea	esbe(pc),a2 
	move.l	a1,(a2) 
	movea.l	20(a0),a1 
	adda.l	a0,a1 
	lea	songbase(pc),a2 
	move.l	a1,(a2) 
	lea	samplebase(pc),a2 
	movea.l	24(a0),a1 
	adda.l	a0,a1 
	move.l	a1,(a2) 
	lea	samplebasis(pc),a2
	movea.l	28(a0),a1 
	adda.l	a0,a1 
	move.l	a1,(a2) 
	rts 

rout	movem.l	a0-a4/d0-d6,-(a7) 
	moveq	#0,d6 
	move.w	l00c5(pc),d0
	beq.b	playit
	move.w	#0,dmacon 
	move.l	d6,l003d
	move.l	d6,l0042
	move.l	d6,l0047
	move.l	d6,l004c
	movem.l	(a7)+,a0-a4/d0-d6 
	rts 

playit:	move.w	d6,dmacon2
	lea	voice1(pc),a0 
	bsr	swork 
	move.l	d0,-(a7)
	lea	voice2(pc),a0 
	bsr	swork 
	move.l	d0,-(a7)
	lea	voice3(pc),a0 
	bsr	swork 
	move.l	d0,-(a7)
	lea	voice4(pc),a0 
	bsr	swork 
	move.l	d0,-(a7)
	bsr	set_waves 
	move.w	dmacon2(pc),d0
	beq.b	l008e 
	or.w	d0,dmacon 
	bsr	set_waves 
	movea.l	l00c7(pc),a0
	move.w	l00c8(pc),d0
	movea.l	l00ca(pc),a1
	move.w	l00cb(pc),d1
	movea.l	l00cd(pc),a2
	move.w	l00ce(pc),d2
	movea.l	l00d0(pc),a3
	move.w	l00d1(pc),d3
	move.l	(a7)+,l004c 
	move.l	(a7)+,l0047 
	move.l	(a7)+,l0042 
	move.l	(a7)+,l003d 
	move.l	a0,voice1dat
	move.w	d0,l003c
	move.l	a1,voice2dat
	move.w	d1,l0041
	move.l	a2,voice3dat
	move.w	d2,l0046
	move.l	a3,voice4dat
	move.w	d3,l004b
	bsr	set_waves 
	bra.b	l008f 


l008e:	move.l	(a7)+,l004c 
	move.l	(a7)+,l0047 
	move.l	(a7)+,l0042 
	move.l	(a7)+,l003d 
l008f:	lea	speedsyn(pc),a0 
	subq.w	#1,(a0)+
	bne.b	endesyn 
	move.w	(a0),-(a0)
	moveq	#0,d5 
	moveq	#6,d6 
	lea	voice1(pc),a0 
	bsr.s	work
	lea	voice2(pc),a0 
	bsr.s	work
	lea	voice3(pc),a0 
	bsr.s	work
	lea	voice4(pc),a0 
	bsr.s	work
endesyn:	bsr	set_freqs 
	movem.l	(a7)+,a0-a4/d0-d6 
return:	rts 



work:	subq.b	#1,60(a0) 
	bpl.b	return
	move.b	61(a0),60(a0) 
work2:	movea.l	24(a0),a1 
getnext:	move.b	(a1)+,d0
	cmp.b	#$ff,d0 
	bne	noendofseq
	movea.l	8(a0),a3
	movea.l	4(a0),a2
	adda.w	58(a0),a2 
	cmpa.l	a3,a2 
	bne.b	songnichtfertig 
	move.w	d5,58(a0) 
	movea.l	4(a0),a2
songnichtfertig:
	moveq	#0,d1 
	moveq	#0,d2 
	move.b	(a2)+,d1
	move.b	(a2)+,78(a0)
	move.b	(a2),d2 
	cmp.w	#$7f,d2 
	ble.b	l009a 
	move.b	d2,d3 
	lsr.w	#4,d3 
	andi.w	#$f,d3
	andi.w	#$f,d2
	cmp.b	#$f,d3
	bne.b	l0097 
	moveq	#$64,d3 
	tst.w	d2
	beq.b	l0096 
	moveq	#$f,d3
	sub.w	d2,d3 
	addq.w	#1,d3 
	add.w	d3,d3 
	move.w	d3,d2 
	add.w	d3,d3 
	add.w	d2,d3 
l0096:	move.b	d3,81(a0) 
	bra.b	nospecial 
l0097:	cmp.b	#8,d3 
	bne.b	l0098 
	lea	l00c5(pc),a2
	st	(a2)
	bra.b	nospecial 
l0098:	cmp.b	#$e,d3
	bne.b	l0099 
	andi.w	#$f,d2
	lea	l00c4(pc),a2
	move.w	d2,(a2) 
l0099:	bra.b	nospecial 
l009a:	move.b	d2,67(a0) 
nospecial	add.w	d1,d1 
	movea.l	seqbase(pc),a3
	adda.w	d1,a3 
	movea.w	(a3),a3 
	adda.l	sogbase(pc),a3
	move.l	a3,24(a0) 
	addi.w	#$c,58(a0)
	bra	work2 
noendofseq:
	cmp.b	#$fe,d0 
	bne.b	nosetlength 
	move.b	(a1),61(a0) 
	move.b	(a1)+,60(a0)
	bra	getnext 
nosetlength:
	cmp.b	#$fd,d0 
	bne.b	nosetpp 
	move.b	(a1),61(a0) 
	move.b	(a1)+,60(a0)
	move.l	a1,24(a0) 
	rts 

nosetpp:	move.b	d0,65(a0) 
	move.b	(a1)+,d1
	move.b	d1,66(a0) 
	andi.w	#$e0,d1 
	beq.b	nosetspecial
	move.b	(a1)+,75(a0)
nosetspecial:
	move.l	a1,24(a0) 
	move.w	d5,28(a0) 
	tst.b	d0
	bmi.s	adsrnotsetnew 
	move.b	66(a0),d1 
	andi.w	#$1f,d1 
	add.b	67(a0),d1 
	movea.l	adsrstart(pc),a2
	add.w	d1,d1 
	adda.w	d1,a2 
	movea.w	(a2),a2 
	adda.l	sogbase(pc),a2
	move.w	d5,56(a0) 
	move.b	(a2),68(a0) 
	move.b	(a2)+,69(a0)
	moveq	#0,d1 
	move.b	(a2)+,d1
	move.b	(a2)+,72(a0)
	moveq	#0,d0 
	move.b	#$40,80(a0) 
	move.b	(a2)+,d0
	move.b	d0,73(a0) 
	move.b	d0,64(a0) 
	move.b	(a2)+,74(a0)
	move.l	a2,16(a0) 
	move.b	d5,70(a0) 
	cmp.b	#$80,d1 
	beq.b	adsrnotsetnew 
	movea.l	arpstart(pc),a2 
	btst	#6,66(a0) 
	beq.b	nosetarp
	move.b	75(a0),d1 
nosetarp:	add.w	d1,d1 
	adda.w	d1,a2 
	movea.w	(a2),a2 
	adda.l	sogbase(pc),a2
	move.l	a2,20(a0) 
	move.w	d5,54(a0) 
	move.b	d5,71(a0) 
adsrnotsetnew:
	rts 

init:	moveq	#0,d5 
	move.w	#0,dmacon 
	move.l	d0,d7 
	mulu	#$c,d7
	move.l	d1,d6 
	addq.l	#1,d6 
	mulu	#$c,d6
	moveq	#3,d0 
	lea	voice1(pc),a0 
	lea	pause(pc),a1
	lea	paulatab(pc),a2 
	lea	blank,a5
initlp:	sf	82(a0)
	move.l	a1,16(a0) 
	move.l	a1,20(a0) 
	move.b	#1,68(a0) 
	move.b	#1,69(a0) 
	sf	70(a0)
	move.w	d5,56(a0) 
	sf	71(a0)
	sf	72(a0)
	sf	73(a0)
	sf	50(a0)
	move.b	d5,64(a0) 
	sf	74(a0)
	sf	75(a0)
	move.b	#$64,81(a0) 
	st	76(a0)
	st	60(a0)
	sf	77(a0)
	sf	79(a0)
	move.w	d5,54(a0) 
	move.w	d5,28(a0) 
	move.w	d5,52(a0) 
	move.w	(a2)+,d1
	move.w	(a2)+,d3
	movea.l	(a2)+,a4
	divu	#3,d3 
	moveq	#0,d4 
	bset	d3,d4 
	move.w	d4,62(a0) 
	mulu	#3,d3 
	andi.l	#$ff,d3 
	andi.l	#$ff,d1 
	move.l	a4,0(a0)
	move.l	a5,(a4)+
	move.w	#$100,(a4)+ 
	move.w	#$100,(a4)+ 
	move.w	#0,(a4)+
	lea	dummy_ff(pc),a3 
	move.l	a3,24(a0) 
	move.l	esbe(pc),4(a0)
	move.l	esbe(pc),8(a0)
	add.l	d6,8(a0)
	add.l	d3,8(a0)
	add.l	d7,4(a0)
	add.l	d3,4(a0)
	move.w	d5,58(a0) 
	lea	84(a0),a0 
	dbf	d0,initlp 
	lea	speedsyn(pc),a0 
	move.w	#1,(a0) 
	move.w	d5,4(a0)
	bra	set_waves 
dummy_ff:	dc.b	$ff,$ff 
swork:	tst.b	71(a0)
	beq.b	arpworkyeah 
	subq.b	#1,71(a0) 
	bra	arpeggiotabende 
arpworkyeah:
	movea.l	20(a0),a1 
	adda.w	54(a0),a1 
arpwork:	moveq	#0,d0 
	move.b	(a1)+,d0
	cmp.w	#$e0,d0 
	blt	 normalapreggio
	subi.w	#$e0,d0 
	add.w	d0,d0 
	move.w	apreggiotab(pc,d0.w),d0 
	jmp	 arp_waitcomm(pc,d0.w) 

apreggiotab:
	dc.b	$00,$18,$02,$b0,$01,$fc,$00,$0a 
	dc.b	$02,'f',$01,'8',$01,$d0,$00,'(' 
	dc.b	$00,$00,$00,$98 

arp_waitcomm:
	move.b	(a1)+,71(a0)
	addq.w	#2,54(a0) 
	bra.b	swork 
	addq.w	#3,54(a0) 
	move.b	(a1)+,72(a0)
	move.b	(a1)+,73(a0)
	bra.b	arpwork 
	moveq	#0,d0 
	move.b	(a1)+,d0
	move.w	d0,54(a0) 
	movea.l	20(a0),a1 
	adda.w	d0,a1 
	bra.b	arpwork 
	moveq	#0,d1 
	move.b	(a1)+,d1
	cmp.b	76(a0),d1 
	beq.b	waveschonan 
	move.b	d1,76(a0) 
	move.w	d0,-(a7)
	move.w	62(a0),d0 
	or.w	d0,dmacon2
	not.w	d0
	and.w	d0,dmacon 
	move.w	(a7)+,d0
	movea.l	samplebase(pc),a4 
	move.w	d1,d3 
	lsl.w	#3,d1 
	add.w	d3,d3 
	add.w	d3,d1 
	adda.w	d1,a4 
	movea.l	0(a4),a2
	adda.l	samplebasis(pc),a2
	movea.l	0(a0),a3
	move.l	a2,(a3)+
	move.w	4(a4),(a3)+ 
	move.w	#4,(a3)+
	moveq	#0,d1 
	move.w	6(a4),d1
	adda.l	d1,a2 
	move.l	a2,12(a0) 
	move.w	8(a4),52(a0)
waveschonan:
	clr.w	56(a0)
	move.b	#1,68(a0) 
	addq.w	#2,54(a0) 
	sf	50(a0)
	bra	arpwork 
	st	76(a0)
	move.w	d0,-(a7)
	move.w	62(a0),d0 
	or.w	d0,dmacon2
	not.w	d0
	and.w	d0,dmacon 
	move.w	(a7)+,d0
	moveq	#0,d1 
	move.b	(a1)+,d1
	movea.l	samplebase(pc),a4 
	move.w	d1,d3 
	lsl.w	#3,d1 
	add.w	d3,d3 
	add.w	d3,d1 
	adda.w	d1,a4 
	movea.l	0(a4),a2
	adda.l	samplebasis(pc),a2
	moveq	#0,d0 
	move.w	4(a2),d0
	move.w	6(a2),d2
	lsl.w	#2,d2 
	mulu	#$18,d0 
	addq.l	#8,a2 
	movea.l	a2,a4 
	adda.l	d0,a2 
	adda.w	d2,a2 
	moveq	#0,d1 
	move.b	(a1)+,d1
	mulu	#$18,d1 
	adda.l	d1,a4 
	move.l	(a4)+,d1
	move.l	(a4)+,d2
	andi.l	#$fffffffe,d1 
	andi.l	#$fffffffe,d2 
	sub.l	d1,d2 
	lsr.l	#1,d2 
	add.l	a2,d1 
	movea.l	0(a0),a3
	move.l	d1,(a3)+
	move.w	d2,(a3)+
	move.w	#4,(a3) 
	move.l	d1,12(a0) 
	pea	(a2)
	movea.l	d1,a2 
	move.b	(a2)+,(a2)
	movea.l	(a7)+,a2
	moveq	#1,d1 
	move.w	d1,52(a0) 
	clr.w	56(a0)
	move.b	#1,68(a0) 
	addq.w	#3,54(a0) 
	sf	50(a0)
	bra	arpwork 
	move.w	d0,-(a7)
	move.w	62(a0),d0 
	or.w	d0,dmacon2
	not.w	d0
	and.w	d0,dmacon 
	move.w	(a7)+,d0
	movea.l	0(a0),a3
	move.w	#4,6(a3)
	moveq	#0,d1 
	move.b	(a1)+,d1
	movea.l	samplebase(pc),a4 
	move.w	d1,d3 
	lsl.w	#3,d1 
	add.w	d3,d3 
	add.w	d3,d1 
	adda.w	d1,a4 
	movea.l	0(a4),a2
	move.l	a2,30(a0) 
	moveq	#0,d0 
	move.w	4(a4),d0
	move.w	d0,d1 
	add.l	d0,d0 
	adda.l	d0,a2 
	move.l	a2,34(a0) 
	move.b	(a1)+,-(a7) 
	move.w	(a7)+,d0
	move.b	(a1)+,d0
	cmp.w	#$ffff,d0 
	bne.b	l00ab 
	move.w	d1,d0 
l00ab:	move.w	d0,38(a0) 
	move.b	(a1)+,-(a7) 
	move.w	(a7)+,d0
	move.b	(a1)+,d0
	move.w	d0,42(a0) 
	move.b	(a1)+,-(a7) 
	move.w	(a7)+,d0
	move.b	(a1)+,d0
	move.w	d0,40(a0) 
	sf	48(a0)
	move.b	(a1)+,49(a0)
	sf	51(a0)
	sf	44(a0)
	st	50(a0)
	clr.w	56(a0)
	move.b	#1,68(a0) 
	addi.w	#9,54(a0) 
	bra	arpwork 
	move.b	(a1)+,-(a7) 
	move.w	(a7)+,d0
	move.b	(a1)+,d0
	move.w	d0,42(a0) 
	move.b	(a1)+,-(a7) 
	move.w	(a7)+,d0
	move.b	(a1)+,d0
	move.w	d0,40(a0) 
	sf	48(a0)
	move.b	(a1)+,49(a0)
	sf	44(a0)
	sf	51(a0)
	addq.w	#6,54(a0) 
	bra	arpwork 
	st	76(a0)
	move.w	d0,-(a7)
	move.w	62(a0),d0 
	or.w	d0,dmacon2
	not.w	d0
	and.w	d0,dmacon 
	move.w	(a7)+,d0
	moveq	#0,d1 
	move.b	(a1)+,d1
	movea.l	samplebase(pc),a4 
	move.w	d1,d3 
	lsl.w	#3,d1 
	add.w	d3,d3 
	add.w	d3,d1 
	adda.w	d1,a4 
	movea.l	0(a4),a2
	adda.l	samplebasis(pc),a2
	movea.l	0(a0),a3
	move.l	a2,(a3)+
	move.w	4(a4),(a3)+ 
	move.w	#4,(a3) 
	moveq	#0,d1 
	move.w	6(a4),d1
	adda.l	d1,a2 
	move.l	a2,12(a0) 
	move.w	8(a4),52(a0)
	clr.w	56(a0)
	move.b	#1,68(a0) 
	addq.w	#2,54(a0) 
	sf	50(a0)
	bra	arpwork 
	moveq	#0,d1 
	move.b	(a1)+,d1
	movea.l	samplebase(pc),a4 
	move.w	d1,d3 
	lsl.w	#3,d1 
	add.w	d3,d3 
	add.w	d3,d1 
	adda.w	d1,a4 
	movea.l	0(a4),a2
	adda.l	samplebasis(pc),a2
	movea.l	0(a0),a3
	move.l	a2,(a3)+
	moveq	#0,d1 
	move.w	6(a4),d1
	adda.l	d1,a2 
	move.l	a2,12(a0) 
	move.w	4(a4),(a3)
	move.w	8(a4),52(a0)
	addq.w	#2,54(a0) 
	sf	50(a0)
	bra	arpwork 
normalapreggio:
	move.b	d0,77(a0) 
	addq.w	#1,54(a0) 
arpeggiotabende:
	tst.b	50(a0)
	beq.s	adsrwork
	tst.b	51(a0)
	bne.s	adsrwork
	subq.b	#1,48(a0) 
	bpl.s	adsrwork
	move.b	49(a0),48(a0) 
	movea.l	30(a0),a1 
	movea.l	34(a0),a2 
	moveq	#0,d0 
	move.w	38(a0),d0 
	move.w	40(a0),d1 
	move.w	42(a0),d2 
	tst.b	44(a0)
	bne.b	l00ae 
	st	44(a0)
	bra.b	l00b0 
l00ae:	ext.l	d1
	add.l	d1,d0 
	bpl.b	l00af 
	st	51(a0)
	sub.l	d1,d0 
	bra.b	l00b0 
l00af:	movea.l	a1,a3 
	move.l	d0,d3 
	add.l	d3,d3 
	adda.l	d3,a3 
	moveq	#0,d3 
	move.w	d2,d3 
	add.l	d3,d3 
	adda.l	d3,a3 
	cmpa.l	a2,a3 
	ble.b	l00b0 
	st	51(a0)
	sub.l	d1,d0 
l00b0:	move.w	d0,38(a0) 
	adda.l	samplebasis(pc),a1
	add.l	d0,d0 
	adda.l	d0,a1 
	move.w	d2,52(a0) 
	move.l	a1,12(a0) 
	movea.l	0(a0),a2
	move.l	a1,(a2)+
	move.w	d2,(a2)+
adsrwork:	tst.b	70(a0)
	beq.b	adsrwork05
	subq.b	#1,70(a0) 
	bra.b	nonewadsr 
adsrwork05:
	subq.b	#1,68(a0) 
	bne.b	nonewadsr 
	move.b	69(a0),68(a0) 
adsrwork2	movea.l	16(a0),a1 
	adda.w	56(a0),a1 
	moveq	#0,d0 
	move.b	(a1)+,d0
	cmp.w	#$e0,d0 
	blt.b	noadsrcommand 
	subi.w	#$e0,d0 
	add.w	d0,d0 
	move.w	adsrtab(pc,d0.w),d0 
	jmp	adsrwcomm(pc,d0.w)

adsrtab:	dc.b	$00,$0a,$00,$16,$00,$16,$00,$16 
	dc.b	$00,$16,$00,$16,$00,$16,$00,$16 
	dc.b	$00,$00 

adsrwcomm	move.b	(a1),70(a0) 
	addq.w	#2,56(a0) 
	bra.b	adsrwork
	moveq	#0,d0 
	move.b	(a1),d0 
	subq.w	#5,d0 
	move.w	d0,56(a0) 
	bra.b	adsrwork2 
	bra.b	nonewadsr 
noadsrcommand:
	move.b	d0,79(a0) 
	addq.w	#1,56(a0) 
nonewadsr	move.b	77(a0),d0 
	bmi.b	notrelse
	add.b	65(a0),d0 
	add.b	78(a0),d0 
notrelse:	andi.w	#$7f,d0 
	lea	freqytab(pc),a1 
	add.w	d0,d0 
	move.w	0(a1,d0.w),d0 
	moveq	#$a,d2
	tst.b	74(a0)
	beq.b	l00b9 
	subq.b	#1,74(a0) 
	bra.b	l00bc 
l00b9:	moveq	#0,d1 
	moveq	#0,d4 
	moveq	#0,d5 
	move.b	80(a0),d6 
	move.b	73(a0),d4 
	move.b	72(a0),d5 
	move.b	64(a0),d1 
	btst	#5,d6 
	bne.b	l00ba 
	sub.w	d5,d1 
	bpl.b	l00bb 
	bset	#5,d6 
	moveq	#0,d1 
	bra.b	l00bb 
l00ba:	add.w	d5,d1 
	cmp.w	d4,d1 
	ble.b	l00bb 
	bclr	#5,d6 
	move.w	d4,d1 
l00bb:	move.b	d1,64(a0) 
	move.b	d6,80(a0) 
	lsr.w	#1,d4 
	sub.w	d4,d1 
	ext.l	d1
	muls	d0,d1 
	asr.l	d2,d1 
	add.l	d1,d0 
l00bc:	btst	#5,66(a0) 
	beq.b	l00be 
	moveq	#0,d1 
	move.b	75(a0),d1 
	bmi.b	l00bd 
	add.w	d1,28(a0) 
	move.w	28(a0),d1 
	mulu	d0,d1 
	lsr.l	d2,d1 
	sub.w	d1,d0 
	bra.b	l00be 
l00bd:	neg.b	d1
	add.w	d1,28(a0) 
	move.w	28(a0),d1 
	mulu	d0,d1 
	lsr.l	d2,d1 
	add.w	d1,d0 
l00be:	move.w	d0,46(a0) 
	tst.b	82(a0)
	beq.b	l00bf 
	movea.l	0(a0),a3
	move.w	#1,6(a3)
	move.w	#0,10(a3) 
l00bf:	swap	d0
	moveq	#0,d1 
	moveq	#0,d2 
	move.b	79(a0),d2 
	lea	voice4sfx(pc),a1
	cmpa.l	a0,a1 
	beq.b	l00c1 
	move.b	81(a0),d1 
	sub.w	fade_out(pc),d1 
	bpl.b	l00c0 
	moveq	#0,d1 
l00c0:	mulu	d1,d2 
	divu	#$64,d2 
l00c1:	move.w	d2,d0 
	rts 

pause:	dc.b	$01,$00,$00,$00,$00,$00,$00,$e1 
	dcb.w	11,0

speedsyn:	dc.b	$00,$00 
l00c4:	dc.b	$00,$00 
l00c5:	dc.b	$00,$00 

voice1:	dcb.w	6,0 
l00c7:	dcb.w	20,0
l00c8:	dcb.w	16,0

voice2:	dcb.w	6,0 
l00ca:	dcb.w	20,0
l00cb:	dcb.w	16,0

voice3:	dcb.w	6,0 
l00cd:	dcb.w	20,0
l00ce:	dcb.w	16,0

voice4:	dcb.w	6,0 
l00d0:	dcb.w	20,0
l00d1:	dcb.w	16,0

voice4sfx	dcb.w	42,0
paulatab:	dc.b	$00,$a0,$00,$00 
	dc.l	voice1dat 
	dc.b	$00,$b0,$00,$03 
	dc.l	voice2dat 
	dc.b	$00,$c0,$00,$06 
	dc.l	voice3dat 
	dc.b	$00,$d0,$00,$09 
	dc.l	voice4dat 
	dc.b	$00,'@' 

seqbase:	dcb.w	2,0 
arpstart:	dcb.w	2,0 
adsrstart	dcb.w	2,0 
esbe:	dcb.w	2,0 
dmacon2:	dc.b	$00,$00 
samplebase:
	dcb.w	4,0 
samplebasis:
	dcb.w	4,0 
songbase:	dcb.w	2,0 
sogbase:	dcb.w	2,0 
fade_out:	dc.b	$00,$00 
freqytab:	dc.b	$06,$B0,$06,'P',$05,$F4,$05,$A0 
	dc.b	$05,'L',$05,$00,$04,$B8,$04,'t' 
	dc.b	$04,'4',$03,$F8,$03,$C0,$03,$8A 
	dc.b	$03,'X',$03,'(',$02,$FA,$02,$D0 
	dc.b	$02,$A6,$02,$80,$02,'\',$02,':' 
	dc.b	$02,$1A,$01,$FC,$01,$E0,$01,$C5 
	dc.b	$01,$AC,$01,$94,$01,'}',$01,'h' 
	dc.b	$01,'S',$01,'@',$01,'.',$01,$1D 
	dc.b	$01,$0D,$00,$FE,$00,$F0,$00,$E2 
	dc.b	$00,$D6,$00,$CA,$00,$BE,$00,$B4 
	dc.b	$00,$AA,$00,$A0,$00,$97,$00,$8F 
	dc.b	$00,$87,$00,$7F,$00,'x',$00,'q' 
	dc.b	$00,'q',$00,'q',$00,'q',$00,'q' 
	dc.b	$00,'q',$00,'q',$00,'q',$00,'q' 
	dc.b	$00,'q',$00,'q',$00,'q',$00,'q' 
	dc.b	$0D,'`',$0C,$A0,$0B,$E8,$0B,'@' 
	dc.b	$0A,$98,$0A,$00,$09,'p',$08,$E8 
	dc.b	$08,'h',$07,$F0,$07,$80,$07,$14 
	even
stack	ds.l	1





*******************
   SECTION DATA
*******************
pic		incbin	pic.pi1

songfile	incbin	amber2.mod	> Amberstar End Sequence Music

	even

; List of files :

; \amberstr.phf\amber.mod	> Amberstar Title Music
; \amberstr.phf\amber2.mod	> Amberstar End Sequence Music
; \lethal_x.phf\lethal.mod	> Lethal Xcess Title Music
; \lethal_x.phf\lethal1.mod	> Lethal Xcess End Sequence Music

*******************
   SECTION BSS
*******************
bssstart

samplebuffer
		ds.w	32768
l00e3

stack_save	ds.l	1
screen_base	ds.l	1
original_rez	ds.w	1
old_palette	ds.w	16
scr_now		ds.l	1

		ds.b	256
screens		ds.b	1		32000

bssend
msdend